<?php
# Hide Adminbar
show_admin_bar(false);

# URL Template
function theme_url()
{
    echo get_template_directory_uri();
}

# URL Blog
function blog_url()
{
    echo bloginfo('url');
}

# Enqueue Frontend Styles
add_action('wp_enqueue_scripts', 'load_css_frames');

function load_css_frames()
{
    //Foundation
    wp_enqueue_style('foundation', get_template_directory_uri() . "/assets/styles/css/foundation.min.css", array(), '', 'all');
    //Motion UI
    wp_enqueue_style('motion-ui', 'https://cdn.jsdelivr.net/npm/motion-ui@1.2.3/dist/motion-ui.min.css', array(), '', 'all');
    //wp-editor
    wp_enqueue_style('wp-editor', get_template_directory_uri() . "/assets/styles/css/wp-editor.css", array(), '', 'all');
    //swiper
    wp_enqueue_style('swiper', get_template_directory_uri() . "/assets/styles/css/swiper.min.css", array(), '', 'all');
    //izimodal
    wp_enqueue_style('izimodal', 'https://cdnjs.cloudflare.com/ajax/libs/izimodal/1.5.1/css/iziModal.min.css', array(), '', 'all');
    //AOS
    wp_enqueue_style('aos', get_template_directory_uri() . "/assets/styles/css/aos.css", array(), '', 'all');
    //Hamburgers
    wp_enqueue_style('hamburgers', get_template_directory_uri() . '/assets/styles/css/hamburgers.css', array(), '', 'all');
    //Calendar
    wp_enqueue_style('Calendario', get_template_directory_uri() . '/assets/styles/css/calendar.css', array(), '', 'all');
    //Style Theme
    wp_enqueue_style('style', get_template_directory_uri() . "/assets/styles/css/main.css", array(), '', 'all');

}

# Enqueue Frontend Styles
add_action('wp_enqueue_scripts', 'load_scripts_frames');

function load_scripts_frames()
{
    //Jquery
    wp_enqueue_script('jquery', get_template_directory_uri() . '/assets/js/jquery.min.js', array(), '', 'all');
    //Foundation
    wp_enqueue_script('foundation', get_template_directory_uri() . '/assets/js/foundation.min.js', array(), '', 'all');
    //Fontawesome
    wp_enqueue_script('fontawesome', get_template_directory_uri() . '/assets/js/fontawesome-all.min.js', '', 'all');
    //IZImodal
    wp_enqueue_script('izimodal', 'https://cdnjs.cloudflare.com/ajax/libs/izimodal/1.5.1/js/iziModal.min.js', array(), '', 'all');
    //Modernizr
    wp_enqueue_script('modernizer', get_template_directory_uri() . '/assets/js/modernizr.js', array(), '', 'all');
    //Calendar
    wp_enqueue_script('Calendario', get_template_directory_uri() . '/assets/js/calendario.js', '', 'all');
    wp_enqueue_script('Calendario-data', get_template_directory_uri() . '/assets/js/data.js', '', 'all');
    //Swiper
    wp_enqueue_script('swiper', get_template_directory_uri() . '/assets/js/swiper.min.js', '', 'all');
    //AOS
    wp_enqueue_script('aos', get_template_directory_uri() . '/assets/js/aos.js', '', 'all');
    //Sript WP
    wp_enqueue_script('script', get_template_directory_uri() . "/assets/js/main.js", array(), '', 'all');
    wp_localize_script( 'script', 'aj_ajax', array(
        'ajaxurl' => admin_url( 'admin-ajax.php' ),
        'aj_nonce' => wp_create_nonce('aj-nonce')
    ));
}

# Remove WP Version
add_filter('the_generator', 'wpbeginner_remove_version');

function wpbeginner_remove_version()
{
    return '';
}

#peticiones
require_once (get_stylesheet_directory() . '/requests/get_data.php');
function add_ajax_actions() {
    //filter page destinos
    add_action( 'wp_ajax_actionGetPost', 'get_posts_custom' );
    add_action( 'wp_ajax_nopriv_actionGetPost', 'get_posts_custom' );
    // add_action( 'wp_ajax_actionGetLikes', 'get_likes' );
    // add_action( 'wp_ajax_nopriv_actionGetLikes', 'get_likes' );
    // add_action( 'wp_ajax_actionUpdateLikes', 'update_likes' );
    // add_action( 'wp_ajax_nopriv_actionUpdateLikes', 'update_likes' );
}
add_action( 'admin_init', 'add_ajax_actions' );

# Register Menu
add_action('init', 'register_menus');

function register_menus()
{
    register_nav_menus(array(
        'main-menu' => __('Main Menu', 'promagazine'),
    ));
}

# Add Thumbnails Support
add_theme_support('post-thumbnails');

function get_excerpt($limit, $source = null)
{

    if ($source == "content" ? ($excerpt = get_the_content()) : ($excerpt = get_the_excerpt())) ;
    $excerpt = preg_replace(" (\[.*?\])", '', $excerpt);
    $excerpt = strip_shortcodes($excerpt);
    $excerpt = strip_tags($excerpt);
    $excerpt = substr($excerpt, 0, $limit);
    $excerpt = substr($excerpt, 0, strripos($excerpt, " "));
    $excerpt = trim(preg_replace('/\s+/', ' ', $excerpt));
    $excerpt = $excerpt . '...';
    return $excerpt;
}

#SMK
include 'assets/inc/smk.php';

# Protect WordPress Against Malicious URL Requests Plugin
include_once(get_stylesheet_directory() . '/assets/inc/security.php');

# Remove Welcome Widget from the Dashboard
add_action('wp_dashboard_setup', 'remove_dashboard_widgets');

function remove_dashboard_widgets()
{
    remove_meta_box('dashboard_quick_press', 'dashboard', 'side');
    remove_meta_box('dashboard_incoming_links', 'dashboard', 'normal');
    remove_meta_box('dashboard_right_now', 'dashboard', 'normal');
    remove_meta_box('dashboard_activity', 'dashboard', 'normal');
    remove_meta_box('dashboard_plugins', 'dashboard', 'normal');
    remove_meta_box('dashboard_recent_drafts', 'dashboard', 'normal');
    remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal');
    remove_meta_box('dashboard_primary', 'dashboard', 'side');
    remove_meta_box('dashboard_secondary', 'dashboard', 'side');
}

remove_action('welcome_panel', 'wp_welcome_panel');

# Reorder admin menu
add_filter('custom_menu_order', 'custom_menu_order');
add_filter('menu_order', 'custom_menu_order');

function custom_menu_order($menu_ord)
{
    if (!$menu_ord) return true;
    return array(
        'index.php', // Dashboard
        'separator1', // First separator
        'home-edit', // Posts / Entradas
        'edit.php', // Posts / Entradas
        'edit.php?post_type=post', //
        'edit.php?post_type=videos_qro', //
        'edit.php?post_type=revistas_qro', //
        // 'edit.php?post_type=posts_mty', //
        // 'edit.php?post_type=videos_mty', //
        // 'edit.php?post_type=revistas_mty', //
        // 'edit.php?post_type=posts_chih', //
        // 'edit.php?post_type=videos_chih', //
        // 'edit.php?post_type=revistas_chih', //
        // 'edit.php?post_type=posts_leon', //
        // 'edit.php?post_type=videos_leon', //
        // 'edit.php?post_type=revistas_leon', //
        'separator-last', // Last separator
    );
}

# Theme Widgets
add_action('widgets_init', 'puedesdecirno_widgets_init');

function puedesdecirno_widgets_init()
{
    register_sidebar(array(
        'name' => __('Sidebar Widget Area', 'puedesdecirno'),
        'id' => 'primary-widget-area',
        'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
        'after_widget' => "</li>",
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ));
}

#-------------------------------------------------------------------------------------------------------------------------#
#-----------------------------------     FUNCIONES CUSTOM BY CANALLA TI    -----------------------------------------------#
#-------------------------------------------------------------------------------------------------------------------------#

/**
 *    vince_check_active_menu()
 *
 *    Te indica en que pagina estas y agrega una clase llamada "is-active".
 *
 * @author David Lopes Diaz
 * @version 1.0
 * @category Menu
 * @return string 'is-active'
 * @date 25-09-2018
 */
function vince_check_active_menu($menu_item)
{
    $actual_link = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    if ($actual_link == $menu_item->url) {
        return 'is-active';
    }
    return '';
}

/**
 *    the_slug()
 *
 *    Regresa el slug de la pagina en la que estas.
 *
 * @author Edgar Olivas Guzmán
 * @version 1.0
 * @category Tags, Posts
 * @return string $slug
 * @date 25-09-2018
 */
function the_slug($echo = true)
{
    $slug = basename(get_permalink());
    do_action('before_slug', $slug);
    $slug = apply_filters('slug_filter', $slug);
    if ($echo) $slug;
    do_action('after_slug', $slug);
    return $slug;
}

/**
 *    get_excerpt_custom()
 *
 *    Obtiene el except del post con un numero de caracteres limitados.
 *
 * @author Edgar Olivas Guzmán
 * @version 1.0
 * @category Tags, Posts
 * @return string $excerpt
 * @date 25-09-2018
 */
function get_excerpt_custom($size = 50)
{
    $excerpt = get_the_content();
    $excerpt = preg_replace(" ([.*?])", '', $excerpt);
    $excerpt = strip_shortcodes($excerpt);
    $excerpt = strip_tags($excerpt);
    $excerpt = substr($excerpt, 0, $size);
    $excerpt = substr($excerpt, 0, strripos($excerpt, " "));
    $excerpt = trim(preg_replace('/s+/', ' ', $excerpt));
    return $excerpt;
}

/**
 * rudr_filter_by_the_author()
 *
 * Agrega el filtro de "Colaboradores" al administrador.
 *
 * @implementador Alejandro Villagómez Ramos
 * @category Filter, Filters
 * @return string $params
 * @date 07-01-2019
 * @referencias:
 *	https://rudrastyh.com/wordpress/filter-posts-by-terms.html
 *	https://rudrastyh.com/wordpress/filter-posts-by-author.html
 */

function rudr_filter_by_the_author() {

    global $typenow;

    $params = array(
        'name' => 'author', // this is the "name" attribute for filter <select>
        'show_option_all' => 'Colaboradores' // label for all authors (display posts without filter)
    );

    if ( isset($_GET['user']) )
        $params['selected'] = $_GET['user']; // choose selected user by $_GET variable

    wp_dropdown_users( $params ); // print the ready author list
}

add_action('restrict_manage_posts', 'rudr_filter_by_the_author');


    /**
	*
	*	Corrección temporal de el error que tiene el editor Gutenberg
	*
	* @author Edgar Olivas Guzmán
	* @version 1.0
	* @category Gutenberg
	* @date 18-07-2019
	*/
    function gutenbergFix_enqueue() {
        // Make sure you link this to your actual file.
        wp_register_style( 'gutenbergFix', get_template_directory_uri() . '/assets/styles/css/gutenbergFix.css' );
        wp_enqueue_style( 'gutenbergFix' );

    }
    add_action( 'enqueue_block_editor_assets', 'gutenbergFix_enqueue' );

    /**
	*
	*	Quitar rol de administrador
	*
	* @author Edgar Olivas Guzmán
	* @version 1.0
	* @category Users
	* @date 18-07-2019
	*/
    add_action( 'editable_roles' , 'hide_adminstrator_editable_roles' );
    function hide_adminstrator_editable_roles( $roles ){
        if ( isset( $roles['administrator'] ) && !current_user_can('level_10') ){
            unset( $roles['administrator'] );
        }
        return $roles;
    }
?>