<?php /* Template Name: Articulo */ ?>
<?php get_header(); ?>

<?php
$curauth = (get_query_var('author_name')) ? get_user_by('slug', get_query_var('author_name')) : get_userdata(get_query_var('author'));
?>

<?php

if (get_query_var('paged')) {
    $paged = get_query_var('paged');
} elseif (get_query_var('page')) {
    $paged = get_query_var('page');
} else {
    $paged = 1;
}

$paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;

$author_query_id = new WP_Query(
    array(
        'author' => $curauth->ID,
        'post_type' => array(
            'posts_mty',
            'posts_qro',
            'posts_chih',
            'posts_leon'
        ),
        'post_status' => 'publish',
        'posts_per_page' => -1,
        'paged' => $paged,
        'page' => $paged
    )
);
?>

<?php smk_get_template_part('template-parts/components/sections/section-generic-banner-single-autor.php'); ?>

<?php
$slider = 'slider_1';
?>

<?php $perma = get_author_posts_url($curauth->ID); ?>
    <script>
        function goBack() {
            window.history.back();
        }
    </script>
    <div class="section btn_regresar">
        <div class="row">
            <div class="small-12 columns text-right">
                <span onclick="goBack()">
                    <span class="pm-links hover-line-yellow">Regresar</span>
                </span>
            </div>
        </div>
    </div>
    <div class="section contenido_videos single_post">
        <div class="share_social hide-for-small-only">
            <span class="pm-links">COMPARTIR</span>
            <ul class="menu vertical">
                <li>
                    <a href="https://api.whatsapp.com/send?text=<?php echo get_the_permalink(); ?>" target="_blank"
                       class="hide-for-small-only">
                        <i class="fab fa-whatsapp"></i>
                    </a>
                </li>
                <li>
                    <a href="whatsapp://send?text=<?php echo get_the_permalink(); ?>" target="_blank"
                       class="show-for-small-only" data-action="share/whatsapp/share">
                        <i class="fab fa-whatsapp"></i>
                    </a>
                </li>
                <li>
                    <a href="<?php the_permalink(); ?>" sharesocial="facebook" title="<?php the_title() ?>">
                        <i class="fab fa-facebook"></i>
                    </a>
                </li>
                <li>
                    <a href="<?php the_permalink(); ?>" sharesocial="twitter" title="<?php the_title() ?>">
                        <i class="fab fa-twitter"></i>
                    </a>
                </li>
                <li>
                    <a href="<?php the_permalink(); ?>" sharesocial="linkedin" title="<?php the_title() ?>">
                        <i class="fab fa-linkedin"></i>
                    </a>
                </li>
                <li>
                    <a href="mailto:?body=<?php the_permalink(); ?>">
                        <i class="fas fa-envelope"></i>
                    </a>
                </li>
            </ul>
        </div>
        <div class="row">
            <div class="small-12 medium-6 columns contenido_final">
                <div class="contenido_single">
                    <h4 class="pm-h2">Artículos en los que ha participado:</h4> <br>

                    <?php if ($author_query_id->have_posts()) : ?>
                        <!-- the loop -->
                        <?php while ($author_query_id->have_posts()) : $author_query_id->the_post(); ?>

                            <?php $postid = get_the_ID(); ?>
                            <div class="row author_post author_card_pm" style="margin-bottom:20px;">
                                <a href="<?php echo get_the_permalink($postid); ?>">
                                    <div class="">
                                        <div class="small-12 medium-4 columns">
                                            <img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="">
                                        </div>
                                        <div class="small-12 medium-4 columns">
                                            <h4 class="pm-h3">
                                                <?php the_title(); ?>
                                            </h4>
                                            <p class="pm-p">
                                                <?php the_post(); the_excerpt(); ?>
                                            </p>
                                            <a style="color: black;" class="pm-links hover-line-yellow"
                                               href="<?php echo get_the_permalink($postid); ?>">Ver más
                                            </a>
                                        </div>
                                        <div class="small-12 medium-4 columns"> </div>
                                    </div>
                                </a>
                            </div>

                        <?php endwhile; ?>

                        <?php
                        if (function_exists('wp_pagenavi')) {
                            echo '<div class="pagination_custom_pro">';
                            wp_pagenavi(array('query' => $author_query_id));
                            echo '</div>';
                        }
                        ?>
                        <?php wp_reset_postdata(); ?>

                    <?php endif; ?>
                </div>
                <br>
                <div class="share_social_mob show-for-small-only">
                    <span class="pm-links">COMPARTIR</span>
                    <ul class="menu">
                        <li>
                            <a href="https://api.whatsapp.com/send?text=<?php echo get_the_permalink(); ?>"
                               target="_blank" class="hide-for-small-only">
                                <i class="fab fa-whatsapp"></i>
                            </a>
                        </li>
                        <li>
                            <a href="whatsapp://send?text=<?php echo get_the_permalink(); ?>" target="_blank"
                               class="show-for-small-only" data-action="share/whatsapp/share">
                                <i class="fab fa-whatsapp"></i>
                            </a>
                        </li>
                        <li>
                            <a href="<?php the_permalink(); ?>" sharesocial="facebook" title="<?php the_title() ?>">
                                <i class="fab fa-facebook"></i>
                            </a>
                        </li>
                        <li>
                            <a href="<?php the_permalink(); ?>" sharesocial="twitter" title="<?php the_title() ?>">
                                <i class="fab fa-twitter"></i>
                            </a>
                        </li>
                        <li>
                            <a href="<?php the_permalink(); ?>" sharesocial="linkedin" title="<?php the_title() ?>">
                                <i class="fab fa-linkedin"></i>
                            </a>
                        </li>
                        <li>
                            <a href="mailto:?body=<?php the_permalink(); ?>">
                                <i class="fas fa-envelope"></i>
                            </a>
                        </li>
                    </ul>
                </div>
                <hr>
                <div class="commentarios">
                    <div class="fb-comments" data-href="<?php echo $perma; ?>" data-numposts="5"></div>
                </div>
                <hr>
            </div>
            <div class="small-12 medium-3 columns"></div>
            <div class="small-12 medium-3 columns col_eddie">
                <div class="sticky hide-for-small-only">
                    <div class="swiper-container publicidad_paginas">
                        <!-- Additional required wrapper -->
                        <div class="swiper-wrapper">
                            <?php if (have_rows('' . $slider . '', 'option')): ?>
                                <?php while (have_rows('' . $slider . '', 'option')) : the_row(); ?>
                                    <div class="swiper-slide pause_slide"><a href="<?php the_sub_field('link'); ?>"><img
                                                    src="<?php the_sub_field('imagen_pub'); ?>" alt=""></a></div>

                                <?php endwhile; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <!-- <img class="thumbnail_edgar" src="http://placehold.it/300x300"> -->
                    <!-- This sticky element would stick to the window, with a marginTop of 0 -->
                </div>
            </div>
        </div>
    </div>

<?php smk_get_template_part('template-parts/components/comp_newsletter.php'); ?>
<?php get_footer(); ?>